#version 330
#extension GL_EXT_gpu_shader4 : enable
// Grid(y) Perfect Pistons 2Mod01.fsh  by  panna_pudi 

//https://www.shadertoy.com/view/fsScWR
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Fork, all credits to Blackle Mori

//CC0 1.0 Universal https://creativecommons.org/publicdomain/zero/1.0/
//To the extent possible under law, Blackle Mori has waived all copyright and related or neighboring rights to this work.

//In this example we extend the "assume-the-worst" trick to 2 dimensional domain repetition.
const float PI = acos(-1.);
float piston(vec2 p, float width, float height) {
    p.x = abs(p.x) - width;
    p.y -= height;
    return length(max(p,0.0)) + min(0.0, max(p.x,p.y));
}

float piston3D(vec3 p, float width, float height) {
    vec2 p2 = vec2(length(p.xz), p.y);
    return piston(p2, width, height);
}

vec3 erot(vec3 p, vec3 ax, float ro) {
    return mix(dot(p,ax)*ax,p,cos(ro))+sin(ro)*cross(ax,p);
}

float scene(vec3 p) {
    float height = .2; // sin(center.y + center.x+iTime)*2.;
    float width = .3;
    float piston = piston3D(p, width, height) - .03;
    return piston;
}

vec3 norm(vec3 p) {
    mat3 k = mat3(p,p,p)-mat3(0.01);
    return normalize(scene(p) - vec3(scene(k[0]),scene(k[1]),scene(k[2])));
}

vec3 traverseGrid2D( vec2 ro, vec2 rd ) {
    const float GRID_INTERVAL = 1.;

    vec2 grid = floor( ( ro + rd * 1E-2 * GRID_INTERVAL ) / GRID_INTERVAL )
                       * GRID_INTERVAL + 0.5 * GRID_INTERVAL;
    
    vec2 src = ( ro - grid ) / rd;
    vec2 dst = abs( 0.5 * GRID_INTERVAL / rd );
    vec2 bv = -src + dst;
    float b = min( bv.x, bv.y );
    
    return vec3( grid, b );
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (gl_FragCoord.xy - .5 * iResolution.xy) / iResolution.y;
    vec2 mouse = (iMouse.xy - 0.5 * iResolution.xy) / iResolution.y;
    vec3 ro = vec3(0, 0, -7);
    vec3 rd = normalize(vec3(uv, 1.5));
    
    float yrot = .5;
    float zrot = iTime * .2;
    if (iMouse.z > 0.) {
        yrot = clamp(1. - 4. * mouse.y, -0., 3.14 / 2.);
        zrot = 4. * mouse.x;
    }
    
    rd = erot(rd,vec3(1,0,0),yrot);
    ro = erot(ro,vec3(1,0,0),yrot);
    rd = erot(rd,vec3(0,1,0),zrot);
    ro = erot(ro,vec3(0,1,0),zrot);
    ro.y += 1.;
    
    float rl = 0.0;
    vec3 rp = ro + rd * rl;
    float dist;
    vec3 gridCenter;
    float lenToNextGrid = 0.0;
    vec2 normalizeRdXZ = normalize( rd.xz );
    float gridLenMultiplier = 1.0 / length( rd.xz );

    bool hit = false;
    for (int i = 0; i < 200 && !hit; i++) {
        if ( lenToNextGrid <= rl ) {
            rl = lenToNextGrid;
            rp = ro + rd * rl;

            vec3 grid = traverseGrid2D( rp.xz, normalizeRdXZ );
            gridCenter = vec3( grid.x, 0.0, grid.y );
            gridCenter.y -= sin(gridCenter.x + gridCenter.z + iTime) * 2.;

            lenToNextGrid += grid.z * gridLenMultiplier;
        }
        dist = scene(rp - gridCenter);
        hit = dist*dist < 1e-6;
        rl += dist;
        rp += dist * rd;
        if ( abs( dist ) < 1E-3 ) { break; }

        if(distance(rp, ro)>50.)break;
    }
    vec3 n = norm(rp - gridCenter);
    vec3 r = reflect(rd, n);
    float col = length(sin(r*2.)*.5+.5)/sqrt(3.);
    col = col*.1 + pow(col, 6.); 
    gl_FragColor = hit ? vec4(col) : vec4(0.03);
    gl_FragColor = sqrt(gl_FragColor);
}

